from flask_sqlalchemy import SQLAlchemy
from flask import Flask
import os

db = SQLAlchemy()

def init_db(app: Flask):
    # Define the path to the local persistent database file
    db_path = os.path.join(os.path.abspath(os.path.dirname(__file__)), 'todo.db')
    app.config['SQLALCHEMY_DATABASE_URI'] = f'sqlite:///{db_path}'
    app.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False

    db.init_app(app)

    # Create tables only if they don't exist
    with app.app_context():
        from . import models
        db.create_all()
