from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from flask_login import LoginManager

db = SQLAlchemy()
login_manager = LoginManager()
login_manager.login_view = "login"

def create_app(db_uri=None):
    app = Flask(__name__)
    app.config["SECRET_KEY"] = "your-secret-key"

    if db_uri:
        app.config["SQLALCHEMY_DATABASE_URI"] = db_uri
    else:
        raise RuntimeError("No database URI provided")

    db.init_app(app)
    login_manager.init_app(app)

    from app import models
    from app.routes import main
    app.register_blueprint(main)

    return app
